from VisualInterface import *
from NumericInterface import *
from DataInterface import *

from Visuals import *
from Numerics import *
from DataOut import *


nSpinsX = 12
nSpinsY = 4

k = 2.0*pi*vector(1.0,0.0,0.0)          # as of now, commensurate needed for stationany state
zArray = [[1.0,-1.0],[-1.0,1.0]]
phaseArray = [[0.0,0.0],[0.0,0.0]]
phiArray = [[1.0,0.75],[0.75,1.0]]

phiScale = 0.15



Ja = -1.0
Jbx = -1.0
Jby = -1.0
Jad = -1.0

trackSpins = [(0,0)]
dt = .005



visuals = Visuals(nSpinsX, nSpinsY, k)
numerics = Numerics(nSpinsX, nSpinsY, k, zArray, phaseArray, phiArray, phiScale, Ja, Jbx, Jby, Jad, dt, visuals)
dataOut = DataOut(trackSpins, numerics)

visualTk = Tk()
numericTk = Tk()
dataTk = Tk()

visualInterface = VisualInterface(visualTk, visuals)
numericInterface = NumericInterface(numericTk, numerics)
dataInterface = DataInterface(dataTk, dataOut)


visualTk.mainloop()
numericTk.mainloop()
dataTk.mainloop()



